//---------------------------------------------------------------------------
#ifndef exporterH
#define exporterH
//---------------------------------------------------------------------------

#include "3dsftk.h"

class Export3DS
   {
   protected:

      file3ds * file;
      database3ds *db;
      mesh3ds * mobj;
      int mesh_counter;
      int vertex_counter;
      int face_counter;

   public:

      bool PrintError(void);

      bool BeginExport(char * filename);
      void EndExport(void);

      mesh3ds * BeginMesh(int VertexCount, int FaceCount);
      void EndMesh(mesh3ds * mobj);
      void AddVertex(mesh3ds * mobj,  float x, float y, float z, float u, float v);
      void AddFace(mesh3ds * mobj, int v1, int v2, int v3);
      void SetMaterial(mesh3ds * mobj, char * tex_file);

   };

#endif
